/**
* \file: ald_change_level.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Rexaline Xavier  /  RexalineInfancia.Xavier@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "ald_types.h"
#include "util/version_info.h"
#include "util/helper.h"

#define BINARY_NAME "ald_change_level"

extern command_vtable_t change_cmd_vtable;
extern command_vtable_t lock_cmd_vtable;

static command_vtable_t *ald_change_level_cmd_list[] = {
		&lock_cmd_vtable,
		&change_cmd_vtable
};

static void ald_change_level_print_usage(const char *binary_name)
{
	printf("\n");
	printf("%s [options...]\n", binary_name);
	printf("\t-h, --help\tDisplays this utility help and exits.\n");
	printf("\t-v, --version\tDisplays version information and exits.\n\n");
}

static void ald_change_level_print_help(const char *binary_name,
                                        command_vtable_t *commands[],
                                        size_t commands_len)
{
	size_t idx;
	printf("\nAuthorization Level Daemon Change Level Utility\n"
			"\t- Used to change the system security level with the help of the ADIT authorization level daemon\n\n");
	printf("%s [<COMMAND>] [options...]\n", binary_name);
	printf("\t-h, --help\tDisplays some help and exits\n");
	printf("\t-v, --version\tDisplays version information and exits\n\n");
	printf("Supported commands:\n");
	for (idx = 0;idx < commands_len;idx++)
		printf("\t%10s \t%s\n",commands[idx]->command, commands[idx]->command_description);
	printf("\nUse %s <COMMAND> --help to get more information on the\nusage of the respective command\n\n", binary_name);
}

static void ald_change_level_print_version(const char *binary_name)
{
	printf("%s - %s\n", binary_name, VERSION_INFO_FORMATED_LINE);
}

static error_code_t ald_change_level_init(int argc, char *argv[], command_vtable_t **current_cmd)
{
	error_code_t result = RESULT_OK;

    result = helper_find_parse_init_command(
                                argc, argv,
                                ald_change_level_cmd_list, ARRAY_SIZE(ald_change_level_cmd_list),
                                BINARY_NAME,
                                &ald_change_level_print_help,
                                &ald_change_level_print_version,
                                &ald_change_level_print_usage,
                                current_cmd);

	return result;
}

static error_code_t ald_change_level_start(command_vtable_t *current_cmd)
{
	error_code_t result = RESULT_OK;

	if ((current_cmd != NULL) && (current_cmd->start != NULL))
		result = current_cmd->start();

	return result;
}

static void ald_change_level_deinit(command_vtable_t *current_cmd)
{
	if ((current_cmd != NULL) && (current_cmd->deinit != NULL))
		current_cmd->deinit();
}

int main(int argc, char *argv[])
{
	error_code_t result = RESULT_OK;
	command_vtable_t *current_cmd = NULL;

	result = ald_change_level_init(argc, argv, &current_cmd);

	if (result == RESULT_OK)
		result = ald_change_level_start(current_cmd);

	ald_change_level_deinit(current_cmd);

	if (result != RESULT_OK)
		return 1;

	return 0;

}







